using System.Diagnostics;
using System.IO;
using Microsoft.AspNetCore.StaticFiles;
using Microsoft.Extensions.FileProviders;
using Microsoft.Extensions.Logging;

namespace MiniApiStaticFileDemo
{
    public partial class Program
    {
        private static void Main(string[] args)
        {
            var builder = WebApplication.CreateSlimBuilder(args);
            // ѡؾ̬ļãҪ
            builder.Services.Configure<StaticFileOptions>(builder.Configuration.GetSection("StaticFile"));

            var app = builder.Build();

            // 1. ãָҪ¶Ŀ¼URLǰ׺
            string baseDir = AppContext.BaseDirectory; // Ŀ¼Ĭbin/Debug/net8.0
            string exposeDir = Path.Combine(baseDir, "GeoIP"); // Ҫ¶Ŀ¼Ŀ¼µGeoIPļУ
            string urlPrefix = "/geoip"; // ͻ˷ǰ׺ͨ http://localhost:5000/geoip ʣ

            try
            {
                // Ŀ¼ڣԴ
                if (!Directory.Exists(exposeDir))
                {
                    Console.WriteLine($"Ŀ¼ڣڳԴ: {exposeDir}");
                    Directory.CreateDirectory(exposeDir);
                    Console.WriteLine($"Ŀ¼ɹ: {exposeDir}");                   
                }
                // Ŀ¼ļΪգԴ3ʾļ
                if (Directory.EnumerateFiles(exposeDir).Count() == 0)
                {
                    Console.WriteLine($"Ŀ¼ΪգڳԴʾļ...");
                    string[] sampleFiles = new string[] { "test.txt", "test2.txt", "test3.txt" };
                    foreach (string file in sampleFiles)
                    {
                        string filePath = Path.Combine(exposeDir, file);
                        File.WriteAllTextAsync(filePath, $"ļ {file} һڲԵʾļ\nͨʴļ");
                        Console.WriteLine($"Ѵʾļ: {filePath}");
                        Thread.Sleep(1000); // ȷļʱв
                    }
                }
            }
            catch (Exception ex)
            {
                // Ŀ¼ҲʧܣȨ޲㣩
                Console.WriteLine($"޷̬ļĿ¼: {exposeDir} - ({ex.Message})");
                throw new InvalidOperationException($"ʧܣ޷Ŀ¼ '{exposeDir}'Ȩޡ");
            }

            // 2. þ̬ļʱ¶Ŀ¼µļ
            app.UseStaticFiles(new StaticFileOptions
            {
                FileProvider = new PhysicalFileProvider(exposeDir),
                RequestPath = urlPrefix
            });

            // 3. Ŀ¼ĬϽãԶʽ
            app.UseDirectoryBrowser(new DirectoryBrowserOptions
            {
                FileProvider = new PhysicalFileProvider(exposeDir),
                RequestPath = urlPrefix, // 뾲̬ļ·һ
                Formatter = new SortableDirectoryFormatter("GeoIP ԴĿ¼") // Զҳ
            });

            // 4. Խӿڣ֤Ƿ
            app.MapGet("/", () => Results.Ok(new
            {
                Status = "Running",
                Message = "MiniAPI ̬ļ",
                StaticFileAccess = $"{urlPrefix}/ļ{urlPrefix}/test.txt",
                DirectoryBrowse = $"{urlPrefix}Ŀ¼б"
            }));

            // 5. 񣨼IP5000˿ڣ
            app.Run("http://*:5000");
        }
    }
}